package chess4j.board;

import java.util.ArrayList;
import java.util.List;

public class KingSquares {

	public static List<Square> getSquares(Square sq) {
		List<Square> kingSquares = new ArrayList<Square>();
		Rank rank = sq.rank();
		File file = sq.file();
		
		// north 1, west 1
		if (rank.southOf(Rank.RANK_8) && file.eastOf(File.FILE_A)) 
			kingSquares.add(Square.valueOf(file.west(),rank.north()));
		// north 1
		if (rank.southOf(Rank.RANK_8)) 
			kingSquares.add(Square.valueOf(file,rank.north()));
		// north 1, east 1
		if (rank.southOf(Rank.RANK_8) && file.westOf(File.FILE_H)) 
			kingSquares.add(Square.valueOf(file.east(),rank.north()));
		// east 1
		if (file.westOf(File.FILE_H)) 
			kingSquares.add(Square.valueOf(file.east(),rank));
		// south 1, east 1
		if (rank.northOf(Rank.RANK_1) && file.westOf(File.FILE_H)) 
			kingSquares.add(Square.valueOf(file.east(),rank.south()));
		// south 1
		if (rank.northOf(Rank.RANK_1)) 
			kingSquares.add(Square.valueOf(file,rank.south()));
		// south 1, west 1
		if (rank.northOf(Rank.RANK_1) && file.eastOf(File.FILE_A)) 
			kingSquares.add(Square.valueOf(file.west(),rank.south()));
		// west 1
		if (file.eastOf(File.FILE_A)) 
			kingSquares.add(Square.valueOf(file.west(),rank));
		
		
		return kingSquares;
	}
}
